using System;
using System.Collections.Generic;
using System.Windows.Forms;
using PsionRFIDDemo.ExecManager;

namespace LF_DEMO
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [MTAThread]
        static void Main()
        {
            string appName = "LF Demo";
            using (var execMgr = new AppExecutionManager(appName))
            {
                if (!execMgr.IsFirstInstance)
                {
                    MessageBox.Show(appName + " already running", "Reminder", MessageBoxButtons.OK,
                                    MessageBoxIcon.Asterisk, MessageBoxDefaultButton.Button1);
                    return; // exit app
                }

                Application.Run(new Main());
            }
        }
    }
}